#include <bits/stdc++.h>

using namespace std;

typedef long long ll;
typedef long double ld;
typedef vector<int> vi;
typedef vector<ll> vl;
typedef vector<double> vd;
typedef vector<ld> vld;
typedef pair<int, int> pi;

template<int maxn>
struct segtree{

    struct update{
        int x;

        update(int x = INT32_MIN):x(x) {}

        update& operator+=(const update& other){
            x = max(x, other.x);

            return *this;
        }

        update operator+(const update& other){
            auto tmp = *this;

            return tmp += other;
        }
    };

    struct node{
        int x;

        node(int x = INT32_MIN) : x(x) {}

        node& operator+= (const node& other){
            x = max(x, other.x);
            return *this;
        }

        node operator+(const node& other){
            auto tmp = *this;
            return tmp += other;
        }

        node& operator+= (const update& other){
            x = max(x, other.x);
            return *this;
        }

        node operator+(const update& other){
            auto tmp = *this;

            return tmp += other;
        }
    };

    node a[2*maxn];
    update b[2*maxn];

    void init(){
        for (int i = maxn; i < 2*maxn; ++i){
            a[i] = node{};
            b[i] = update{};
        }

        for (int i = maxn-1; i > 0; --i){
            a[i] = a[2*i] + a[2*i+1];
            b[i] = b[2*i] + b[2*i+1];
        }
    }

    void push(int pos){

        if (b[pos].x == INT32_MIN) return;

        a[pos] += b[pos];

        if (pos<maxn){
            b[2*pos] += b[pos];
            b[2*pos+1] += b[pos];
        }

        b[pos] = update{};
    }

    void dodaj(int pos){
        pos += maxn-1;

        a[pos].x += 1;

        while(pos>1){
            pos /= 2;
            a[pos] = a[pos*2] + a[pos*2 + 1];
        }
    }

    void pset(int pos){
        pos += maxn-1;

        a[pos].x = 0;

        while(pos>1){
            pos /= 2;
            a[pos] = a[pos*2] + a[pos*2 + 1];
        }
    }

    void add(int l, int r, update x, int pos = 1, int L = 1, int R = maxn){
        push(pos);

        if (l <= L && R <= r){
            b[pos] += x;
            push(pos);

            while(pos>1){
                pos/=2;
                a[pos] = a[2*pos] + a[2*pos+1];
            }

            return;
        }

        if (l > R || L > r) return;

        int mid = (L+R)/2;
        add(l,r,x,2*pos,L,mid);
        add(l,r,x,2*pos+1,mid+1,R);
    }

    node get(int l, int r, int pos = 1, int L = 1, int R = maxn){
        push(pos);
        if (l <= L && R <= r){
            return a[pos];
        }

        if (l > R || L > r) return node{};

        int mid = (L+R)/2;

        return get(l,r,2*pos,L,mid) + get(l,r,2*pos+1,mid+1,R);
    }
};
segtree<4*131072> drvo;

int Slamke(int n, int* a, int m, int* t, int* x, int* y){
    drvo.init();

    for (int i = 1; i <= n; ++i){
        if (a[i] == 1)
            drvo.pset(i);
    }
    int sol = 0;
    for (int i = 1; i <= m; ++i){
        if (t[i] == 1){
            int k = drvo.get(x[i], y[i]).x;

            drvo.add(x[i], y[i], k);
        } else {
            int k = drvo.get(x[i], x[i]).x;

            if (k == INT32_MIN) continue;

            sol = max(sol,k+1);

            drvo.dodaj(x[i]);
        }
    }

    return sol;
}